<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mml="http://www.w3.org/1998/Math/MathML">
	<!--date="20030401" stylesheet version="v1.1.1"-->
	<xsl:output method="html"/>
	<!-- 
******************************************************************************************************************************
* US-APPLICATION-BODY XSL Transformation
* DTD Version:   v1.1   2003   FEBRUARY 
* Stylesheet Version: v1.1.2  October 2003 matched for beta testing of the ABX. File size must be = 83497 bytes.
******************************************************************************************************************************
*	Contacts: 
*		US PTO:	
*	William Stryjewski: william.stryjewski@uspto.gov
*	Jenna Davis: jenna.davis@ustpo.gov
*	Julie Fraser; julie.fraser@uspto.gov 
*
*	Changes prepared for US PTO by Lockheed Martin Information Technology
******************************************************************************************************************************
*     Note that this style sheet is optimized for the msxml.dll shipped with Windows XP and Internet Explorer 6.0. 
*	If you have one of these products, you do not have to upgrade. To upgrade use this link:
*	http://msdn.microsoft.com/downloads/default.asp?url=/downloads/sample.asp?url=/msdn-files/027/001/772/msdncompositedoc.xml
******************************************************************************************************************************
*	HISTORY:
*	v1.0  2001 NOVEMBER 
*  	contacts:
* 	WIPO:  John Dunning; john.dunning@wipo.int
* 	http://pcteasy.wipo.int/efiling_standards/schemaDocs/application-body.xsl
*	*************************************************************************************************************************
*	10/15/03	Added bullet symbol &#9679; for unordered list item.
*	10/14/03	Edited claim-text template so, that first caim-text indents as a paragraph. All nested claim texts have indentation.
*	10/08/03	Edited section names.
*				Deleted label "Drawings"
*	10/07/03	Version changed from 1.1.1 to 1.1.2.
*				Put: History in reverse order;
*				labels for Definition List;
*				labels for Bio deposit.
*				Removed label for figures.
*				Removed extra periods in "patcit" and "bio-deposit".
*				Removed label "Table" for image in the "tables" tag.
				Deleted Math Player support.
*	07/01/03	Adjusted lables for table imges and figures.(?)
*	06/18/03	Fixed problem for vertically merged table cells and changed  table Title rendering. Now use Caption for Title.
*				Adjusted headings.
*	06/17/03	Added control image according to attribute "inline" (no/yes) in paragraphs.
*				Fixed problem with maths tag (img or math).
*	06/09/03	Fixed limit size for embeded images in paragraphs. Changed table layout for paragraph.
*	06/02/03	Changed limit for sizes according to Page Setup: L=1", R=0.75"; T=1"and B=0.25"
*				If hight or width equil zero put max size.
*	05/15/03	Made smaller font size for "sup" and "sub" elements - 70%
*	05/12/03	Changed template for Patent Citations.
*				Developed template for Bio-Deposit.
*				Restored heading for Drawings section.
*				Put lables for Table images and Figures.(?)
*	04/24/03	CSS for unordered bullets has changed (listItemBullet).
*				Added limit for image size in the figures.
* 	04/01/03	Version changed from v1.1.0  to v1.1.1
*				Deleted formatting for first claim-text in the claim.
*				Fixed problem with empty table entry.
*				Deleted table for figures.
*				Added table title rendering.
*	03/19/03	New version v1.1.0 corrected for new application-body.dtd.
*				"us-application-body" root name changed to "application-body".
*				Added "ol-style" for ordered list.
*				Default headings (without level attribute) became level = 2 (h3 HTML tag)
*				Deleted multilingual support.
*				Added rendering table as an image.
*				Changed format for name_group rendering. (former "full_name_format")
*				Added address_group template.
*				Format for generated headings changed to default size (h3 HTML tag).
*******************************************************************************************************************************
*	11/22/02 	Font size changed from fixed to relative one.
* 	11/19/02		MathPlayer turned on for rendering MathML. 
*				MathPlayer can be downloaded for free from http://www.dessci.com/en/products/mathplayer/welcome.asp
*	11/11/02 	(version v02 to v03)
*				Made changes according to recommendations EFS WG:
*				The stylesheet should ensure that the claims, the abstract, and the drawings begin printing on a new sheet of paper. 
*				The abstract should include the title of invention prior to the abstract heading.
*				No heading “Drawings” should be displayed in the figures section.  
*				A figure numeric label should not be displayed for each figure.  
*				The numeric label for the claims will be displayed as [c#}. 
* 	09/14/02 	New version v01 for new us-application-body.dtd
*******************************************************************************************************************************
-->
	<!-- key to generate hyperlinks for figref when 'num' attribute is used. -->
	<xsl:key name="fig_ref" match="figure" use="@num"/>
	<!-- parameter to generate language-appropriate text -->
	<xsl:param name="lang" select="translate(//application-body/@lang,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
	<xsl:template match="/">
		<!-- The root element of the document instance; creates an HTML document context -->
		<html xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<!--MathPlayer can be downloaded for free from http://www.dessci.com/en/products/mathplayer/welcome.asp -->
				<!--object id="MathPlayer" classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987"/>
				<xsl:processing-instruction name="import">
					<xsl:text>namespace="mml" implementation="#MathPlayer"</xsl:text>
				</xsl:processing-instruction-->
				<!--meta http-equiv="Content-Type" content="text/html"/-->
				<xsl:call-template name="css_styles"/>
			</head>
			<body>
				<basefont face="Arial Unicode MS, Lucida Sans Unicode, Times New Roman" size="larger">
				Electronic Version <xsl:value-of select="/application-body/@dtd-version"/>
					<br/>Stylesheet Version v1.1.2
					<div style="margin-left: +35pt;">
						<xsl:apply-templates select="//doc-page"/>
						<xsl:apply-templates select="//description"/>
						<xsl:apply-templates select="//claims"/>
						<xsl:if test="//abstract">
							<xsl:apply-templates select="//abstract" mode="create_abstract"/>
						</xsl:if>
						<xsl:apply-templates select="//drawings"/>
					</div>
				</basefont>
			</body>
		</html>
	</xsl:template>
	<!-- *********************************************************************
     *  GENERATES SECTION HEADINGS, ANCHORS FOR CROSS-REFERENCES         *
     *********************************************************************
-->
	<xsl:template match="description">
		<a name="{@id}"/>
		<h1 align="center"> Description </h1>
		<xsl:choose>
			<xsl:when test="./doc-page">
				<xsl:apply-templates select="doc-page" mode="doc_page"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="claims">
		<div class="breakBefore">
			<a name="{@id}"/>
			<h1 align="center"> Claims </h1>
			<xsl:choose>
				<xsl:when test="./doc-page">
					<xsl:apply-templates select="doc-page" mode="doc_page"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	<xsl:template match="drawings">
		<div class="breakBefore">
			<a name="{@id}"/>
			<!--h1 align="center">
				<xsl:call-template name="drawing_ChoiceText"/>
				Drawings
			</h1-->
			<xsl:choose>
				<xsl:when test="./doc-page">
					<xsl:apply-templates select="doc-page" mode="doc_page"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	<!-- *********************************************************************
     *  GENERATE HEADINGS FOR SECTIONS WITHOUT THEM, CROSS-REFERENCES    *
     *********************************************************************
     * sub-headings; each is tested for presence of a <heading>; if one  *
     * is present, that will be used, otherwise the generic heading will *
     * be generated                                                      *
     *********************************************************************
-->
	<xsl:template match="technical-field">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Technical Field</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="background-art">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Background Art</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="description-of-drawings">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Description of Drawings</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="disclosure">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Disclosure</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="tech-problem">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Technical Problem</b>
			</h3>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="tech-solution">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Technical Solution</b>
			</h3>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="best-mode">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Best Mode</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="mode-for-invention">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Mode for Invention</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="industrial-applicability">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Industrial Applicability</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="sequence-list-text">
		<a name="{@id}"/>
		<xsl:if test="not(child::heading)">
			<h3 class="heading">
				<b>Sequence List Text</b>
			</h3>
			<br/>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<!-- NOTE:  At the moment, we are incapable of rendering MathML coded text.  This
            template will generate text that will notify the reader that markup
            is included.  In the future, we hope to support MathML->PDF,
            MathML->SVG, etc. 
            This style sheet is used MathPlayer to render MathML-->
	<xsl:template match="maths">
		<xsl:choose>
			<xsl:when test="./math">
				<xsl:element name="mml:math">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="./img">
				<xsl:apply-templates/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="math//*">
		<!--***************Just put mathml tags into html***************-->
		<xsl:element name="mml:{local-name(.)}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template name="css_styles">
		<!--To make font relative following changes were made for font size:
	font size: 8 pt. changed to "small"
	font size: 10 pt. changed to "medium"
	font size: 12 pt. changed to "large"
	font size: 14 pt. changed to "larger"
	font size: 22 pt. changed to "x-large"
	-->
		<style type="text/css">
			/* hyperlink */
             a     {text-decoration: none;color:blue;background-color:white}
			/* visited hyperlink */
             a:visited {color: blue; background-color:white}
           		 /* avoid a page break (in supported browsers) */
            .avoidBreak {page-break-inside: avoid; }
            		/* break page before content */
            .breakBefore {page-break-before: always;}
           		 /* break page after content */ 
		.breakAfter {page-break-after: always;}
			/* indents claim-text within containing element */
            .claim_ChoiceText {margin-left: +30pt;
                         font-size: medium;
                         line-height: 200%;}
			/* use for development */
 		.flag {  font-size: medium;
  			     color: red;
 			     background-color: yellow;
                         vertical-align: top;
 			   }
             .heading { margin-top: 3px;
                              margin-bottom: 3px;
                              text-transform: uppercase;}
             /*h3     { margin-top: 3px; */
             /*        margin-bottom: 3px; */
             /*        font-weight: normal;} */
            .leftPara {margin-top: 8px;
                        margin-bottom: 8px;
                        margin-left: -30pt;}
			/* displays a bullet as the glyph for li */
		.listItemBullet { list-style-type: none;
					/* list-style-position: outside; */
					display: list-item;
					margin-left: -10pt;
					/* margin-left: +30pt; */
					line-height: 200%;}
			/* displays a dash as the glyph for li */
            .listItemDash  { list-style-type: none;
               				   display: list-item;
                               margin-left: -10pt;
                               line-height: 200%;}
			/* displays no glyph for li */
            .listItemNone  { list-style-type: none;
               				   display: list-item;
                               margin-left: -10pt;
                               line-height: 200%;}
			/* formats list-items */
            .listItem { list-style-type: disc;
                         display: list-item;
                         margin-left: +30pt;
                         line-height: 200%;}
			/* formats text in monospaced font */
            .mono       {line-height: 200%;
                        font-family: monospace;}
			/* paragraph text formatting */
            .para_ChoiceText {line-height: 200%;
                        font-size: medium;
                        margin-top: 8px;
                        margin-bottom: 8px;}
			/* formatting for major sections of document */
            .section {font-size: large;
                      line-height: 200%;}
			/* formats text in small capitals */
            .smallcaps     {text-transform: uppercase;
                         font-size: smaller; }            
			/* applies page-break after tables */
			.tableBreakAfter { border-collapse: collapse;
								  page-break-after: always;
	 						    }
			/* applies page-break before tables */
			.tableBreakBefore { border-collapse: collapse;
								  page-break-before: always;
	 						    }
            /* formats table cell display data */
            .tableData {font-size: medium;
                       vertical-align: top;
                       }
            /* formats table cell display data */
            .tableDataAppBody {font-size: medium;
                                 vertical-align: top;
                                  }
			/* formats table head data */
            .tableHead {font-size: large;
                         font-weight: bold; 
                         margin-top: 2em; 
                         margin-bottom: 2em;}
			/* table data bottom (not center) */
			.tdB {border-bottom: 1px;
					border-bottom-color: black;
					border-bottom-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data bottom center */
			.tdBC {border-bottom: 1px;
					border-bottom-color: black;
					border-bottom-style: solid;
					border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					border-right: 1px;
					border-right-color: black;
					border-right-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data center */
			.tdC { border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					border-right: 1px;
					border-right-color: black;
					border-right-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data left*/
			.tdL { border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					font-size: medium;
                    vertical-align: top;}
			/* table data left bottom  */
			.tdLB { border-bottom: 1px;
					 border-bottom-color: black;
					 border-bottom-style: solid;
					 border-left: 1px;
					 border-left-color: black;
					 border-left-style: solid;
					 font-size: medium;
                     vertical-align: top;}
			/* table data left top and bottom  */
			.tdLTB {border-bottom: 1px;
					 border-bottom-color: black;
					 border-bottom-style: solid;
					 border-top: 1px;
					 border-top-color: black;
					 border-top-style: solid;
					 border-left: 1px;
					 border-left-color: black;
					 border-left-style: solid;
					 font-size: medium;
                     vertical-align: top;}
			/* table data right*/
			.tdR { border-right: 1px;
					border-right-color: black;
					border-right-style: solid;
					font-size: medium;
                    vertical-align: top;}
			/* table data right bottom  */
			.tdRB { border-bottom: 1px;
					 border-bottom-color: black;
					 border-bottom-style: solid;
					 border-right: 1px;
					 border-right-color: black;
					 border-right-style: solid;
					 font-size: medium;
                     vertical-align: top;}
			/* table data top (not center) */
			.tdT { border-top: 1px;
					border-top-color: black;
					border-top-style: solid;
					font-size: medium;
                    vertical-align: top;} 
			/* table data top and bottom (not center) */
			.tdTB {border-bottom: 1px;
					border-bottom-color: black;
					border-bottom-style: solid; 
					border-top: 1px;
					border-top-color: black;
					border-top-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data top and bottom center */
			.tdTBC {border-top: 1px;
					border-top-color: black;
					border-top-style: solid;
					border-bottom: 1px;
					border-bottom-color: black;
					border-bottom-style: solid;	
					border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					border-right: 1px;
					border-right-color: black;
					border-right-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data top center */
			.tdTC {border-top: 1px;
					border-top-color: black;
					border-top-style: solid;
					border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					border-right: 1px;
					border-right-color: black;
					border-right-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* table data top left*/
			.tdTL { border-top: 1px;
					border-top-color: black;
					border-top-style: solid;
					border-left: 1px;
					border-left-color: black;
					border-left-style: solid;
					font-size: medium;
                    vertical-align: top;}
			/* table data top right */
			.tdTR {border-top: 1px;
					border-top-color: black;
					border-top-style: solid;
					border-right: 1px;
					border-right-color: black;
					border-right-style: solid; 
					font-size: medium;
                    vertical-align: top;}
			/* formatting for invention-title */
            .title {display: block;
                    text-align: center;
                    font-size: x-large;
                    font-family:serif;
                    font-weight:bold;
                    margin-top:3mm;
                    margin-bottom: 3mm;}
			/* displays text in UPPER CASE */
            .uc {text-transform: uppercase;}
			/* displays info entered by applicant */
            .userData {font-size: medium;
            			font-weight: bold;
                        vertical-align: top;
                       }
</style>
	</xsl:template>
	<xsl:template match="article">
		<!-- param to pass the date to format_date template (formatting.xsl) -->
		<xsl:param name="date" select="normalize-space(.//pubdate)"/>
		<xsl:choose>
			<xsl:when test="./text">
				<xsl:value-of select="normalize-space(.)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="./author"/>
				<xsl:if test="./atl">
					<xsl:variable name="nAtl" select="normalize-space(./atl)"/>
					<xsl:variable name="nLen" select="string-length($nAtl)"/>
					<xsl:choose>
						<!-- if article title ends in comma, strip and replace with period -->
						<xsl:when test="substring($nAtl,$nLen)=','">
							<xsl:call-template name="rtrim">
								<xsl:with-param name="string" select="$nAtl"/>
							</xsl:call-template>
							<xsl:text>. </xsl:text>
						</xsl:when>
						<!-- if it doesn't end with a period, add one -->
						<xsl:when test="not(substring($nAtl,$nLen)='.')">
							<xsl:value-of select="$nAtl"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="$nAtl"/>
							</xsl:call-template>
						</xsl:when>
						<!-- it ends with a period, just display -->
						<xsl:otherwise>
							<xsl:value-of select="$nAtl"/>
							<xsl:text/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="./subname">
					<xsl:apply-templates select="./subname"/>
				</xsl:if>
				<!-- test for comma -->
				<xsl:choose>
					<!-- book | serial -->
					<xsl:when test="./book-title">
						<i>
							<xsl:value-of select="normalize-space(.//book-title)"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select=".//book-title"/>
							</xsl:call-template>
							<xsl:text/>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<!-- serial -->
						<i>
							<xsl:value-of select="normalize-space(.//sertitle)"/>
							<xsl:choose>
								<!-- if there's following info, format with a comma -->
								<xsl:when test=".//ino | .//vid ">
									<xsl:call-template name="format_comma">
										<xsl:with-param name="string" select="normalize-space(.//sertitle)"/>
									</xsl:call-template>
								</xsl:when>
								<!-- otherwise, use a period -->
								<xsl:otherwise>
									<xsl:call-template name="format_comma">
										<xsl:with-param name="string" select="normalize-space(.//sertitle)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</i>
						<xsl:text/>
					</xsl:otherwise>
				</xsl:choose>
				<!-- end book-title | sertitle -->
				<xsl:if test=".//edition">
					<xsl:call-template name="rtrim">
						<xsl:with-param name="string" select="normalize-space(.//edition)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:choose>
					<xsl:when test=".//pubdate/sdate | .//pubdate/edate">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(./pubdate/sdate)"/>
							<xsl:with-param name="text" select="1"/>
							<xsl:with-param name="lang" select="$lang"/>
						</xsl:call-template>
						<xsl:if test=".//pubdate/edate">
							<xsl:text>, Revised</xsl:text>
							<xsl:call-template name="format_date">
								<xsl:with-param name="date" select="normalize-space(./pubdate/edate)"/>
								<xsl:with-param name="text" select="1"/>
								<xsl:with-param name="lang" select="$lang"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					<xsl:when test=" .//pubdate/text()">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(.//pubdate)"/>
							<xsl:with-param name="text" select="1"/>
							<xsl:with-param name="lang" select="$lang"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
				<xsl:if test="./edition">
					<xsl:value-of select="./edition"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./edition)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./imprint">
					<xsl:choose>
						<xsl:when test=".//address/text">
							<xsl:value-of select="normalize-space(.//imprint/address/text)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test=".//address/city">
								<xsl:value-of select=".//address/city"/>
								<xsl:call-template name="format_comma">
									<xsl:with-param name="string" select="normalize-space(.//address/city)"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test=".//address/state">
								<xsl:value-of select="normalize-space(.//address/state)"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="./imprint/name">
					<xsl:text>: </xsl:text>
					<xsl:value-of select="normalize-space(./imprint/name)"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./imprint/name)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./imprint/pubdate">
					<xsl:text/>
					<xsl:call-template name="format_date">
						<xsl:with-param name="date" select="normalize-space(.//pubdate)"/>
						<xsl:with-param name="text" select="1"/>
						<xsl:with-param name="lang" select="$lang"/>
					</xsl:call-template>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(.//pubdate)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test=".//vid">
					<xsl:text> vol. </xsl:text>
					<xsl:value-of select="normalize-space(.//vid)"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(.//vid)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test=".//ino">
					<xsl:text> no. </xsl:text>
					<xsl:value-of select="normalize-space(.//ino)"/>
					<xsl:choose>
						<!-- if location elements present, write comma -->
						<xsl:when test=".//location">
							<xsl:call-template name="format_comma">
								<xsl:with-param name="string" select="normalize-space(.//ino)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!-- end with period -->
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//ino)"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:apply-templates select="location"/>
				<xsl:if test=".//isbn">
					<xsl:text> ISBN </xsl:text>
					<xsl:value-of select="normalize-space(.//isbn)"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(.//isbn)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test=".//issn">
					<xsl:text> ISSN </xsl:text>
					<xsl:value-of select="normalize-space(.//issn)"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(.//issn)"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
			<!-- end article subelements (not <text>) -->
		</xsl:choose>
	</xsl:template>
	<xsl:template mode="create_abstract" match="abstract">
		<!-- formats the Abstract and its children on a new page -->
		<div class="breakBefore">
			<!--Title of invention should be before abstract-->
			<xsl:apply-templates select="/application-body/description/invention-title"/>
			<h1 align="center">
				<xsl:text>Abstract</xsl:text>
			</h1>
			<xsl:choose>
				<xsl:when test="./doc-page">
					<xsl:apply-templates select="doc-page" mode="doc_page"/>
				</xsl:when>
				<xsl:when test="./abst-problem | ./abst-solution">
					<xsl:apply-templates mode="problem" select="./abst-problem"/>
					<xsl:apply-templates mode="solution" select="./abst-solution"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates mode="abstract_para" select="//abstract/p"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	<xsl:template mode="problem" match="abst-problem">
		<!-- Inserts bold text reading 'Problem:'-->
		<a name="{@id}"/>
		<b>
			<xsl:text> Problem: </xsl:text>
		</b>
		<xsl:apply-templates mode="abstract_para" select="//abst-problem/p"/>
	</xsl:template>
	<xsl:template mode="solution" match="abst-solution">
		<!-- Inserts bold text reading 'Solution:' -->
		<a name="{@id}"/>
		<br/>
		<b>
			<xsl:text>Problem: </xsl:text>
		</b>
		<xsl:apply-templates mode="abstract_para" select="//abst-solution/p"/>
	</xsl:template>
	<xsl:template mode="abstract_para" match="abstract/p | abst-problem/p | abst-solution/p">
		<!-- Formats paragraphs under the Abstract.  Differs from standard paragraph
	     formatting in that this does not show paragraph numbers.-->
		<div class="leftPara">
			<a name="{@id}"/>
			<table border="0" width="100%">
				<tr>
					<td width="8%" valign="top" class="para_ChoiceText">
						<xsl:text/>
					</td>
					<td width="85%" class="para_ChoiceText">
						<xsl:apply-templates/>
					</td>
					<td width="*"/>
				</tr>
			</table>
		</div>
	</xsl:template>
	<xsl:template match="p[ancestor::abstract]"/>
	<xsl:template match="addressbook">
		<xsl:choose>
			<xsl:when test="./text">
				<xsl:value-of select="./text"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="name_group"/>
				<xsl:text>,&#160;</xsl:text>
				<xsl:apply-templates select="./address"/>
				<xsl:for-each select="./phone | ./fax | ./email | ./url | ./ead">
					<xsl:value-of select="local-name(.)"/>
					<xsl:text>: </xsl:text>
					<xsl:value-of select="."/>
					<xsl:text>&#160;</xsl:text>
				</xsl:for-each>
				<xsl:if test="./dtext">
					<xsl:value-of select="."/>
				</xsl:if>
				<xsl:text>.</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="dtext">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="address">
		<!-- Creates a string  to format child elements of address. -->
		<xsl:text>Address:&#160;</xsl:text>
		<xsl:call-template name="address_group"/>
	</xsl:template>
	<xsl:template match="address" mode="tab">
		<!-- Creates a table to format child elements of address. -->
		<xsl:value-of select="./text"/>
		<table width="60%" border="0">
			<xsl:if test="./address-1">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./address-1"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./address-2">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./address-2"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./address-3">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./address-3"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./mailcode">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./mailcode"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./pobox">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./pobox"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./room">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./room"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./floor">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./floor"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./building">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./building"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="./street">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="./street"/>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="tableDataAppBody">
					<xsl:for-each select="./city | ./country | ./state | ./postcode | .//country">
						<xsl:value-of select="."/>
						<xsl:text/>
					</xsl:for-each>
				</td>
			</tr>
			<xsl:for-each select="./email | ./phone | ./fax | ./url | ./ead">
				<tr>
					<td class="tableDataAppBody">
						<xsl:value-of select="."/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template match="author | subname">
		<xsl:choose>
			<xsl:when test="./addressbook">
				<b>
					<xsl:apply-templates/>
				</b>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="name() = 'author'">
					<b>
						<xsl:call-template name="name_group"/>
					</b>
				</xsl:if>
				<xsl:if test="name() = 'subname'">
					<xsl:call-template name="name_group"/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="book" xmlns:doc="urn:schemas-wipo-int:document">
		<!-- param to pass the date to format_date template  -->
		<xsl:param name="date" select="normalize-space(.//pubdate)"/>
		<xsl:choose>
			<xsl:when test="./text">
				<xsl:value-of select="normalize-space(.)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="./author"/>
				<!-- test for comma -->
				<xsl:choose>
					<!-- book | conference -->
					<xsl:when test="./book-title">
						<i>
							<xsl:value-of select="normalize-space(./book-title)"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(./book-title)"/>
							</xsl:call-template>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<!-- conference-->
						<i>
							<xsl:value-of select="normalize-space(.//conftitle)"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//conftitle)"/>
							</xsl:call-template>
						</i>
						<xsl:if test=".//conference/date">
							<xsl:call-template name="format_date">
								<xsl:with-param name="date" select="normalize-space(.//conference/date)"/>
								<xsl:with-param name="text" select="1"/>
								<xsl:with-param name="add_comma" select="1"/>
								<xsl:with-param name="lang" select="$lang"/>
							</xsl:call-template>
							<xsl:text/>
						</xsl:if>
						<xsl:if test=".//confno">
							<xsl:value-of select="normalize-space(.//confno)"/>
							<xsl:text/>
						</xsl:if>
						<xsl:if test=".//confplace">
							<xsl:value-of select="normalize-space(.//confplace)"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//confplace)"/>
							</xsl:call-template>
							<xsl:text/>
						</xsl:if>
						<xsl:if test=".//confsponsor">
							<xsl:text> Sponsored by </xsl:text>
							<xsl:value-of select=".//confsponsor"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//confsponsor)"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<!-- end book-title | conference -->
				<xsl:if test="./subname">
					<xsl:apply-templates select="./subname"/>
				</xsl:if>
				<xsl:if test="./edition">
					<xsl:value-of select="normalize-space(./edition)"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./edition)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./imprint">
					<xsl:choose>
						<xsl:when test="./imprint/address/text">
							<xsl:value-of select="normalize-space(./imprint/address/text)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="./imprint/address/city">
								<xsl:value-of select="normalize-space(./imprint/address/city)"/>
								<xsl:call-template name="format_comma">
									<xsl:with-param name="string" select="normalize-space(./imprint/address/city)"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="./imprint/address/state">
								<xsl:value-of select="normalize-space(./imprint/address/state)"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="./imprint/name">
					<xsl:text>: </xsl:text>
					<xsl:value-of select="normalize-space(./imprint/name)"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./imprint/name)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="./imprint/pubdate/sdate | ./imprint/pubdate/edate">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(./imprint/pubdate/sdate)"/>
							<xsl:with-param name="year_only" select="1"/>
						</xsl:call-template>
						<xsl:if test="./imprint/pubdate/edate">
							<xsl:text>, Revised</xsl:text>
							<xsl:call-template name="format_date">
								<xsl:with-param name="date" select="normalize-space(./imprint/pubdate/edate)"/>
								<xsl:with-param name="year_only" select="1"/>
							</xsl:call-template>
							<xsl:text>. </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="./imprint/pubdate/text()">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(./imprint/pubdate)"/>
							<xsl:with-param name="year_only" select="1"/>
						</xsl:call-template>
						<xsl:text>. </xsl:text>
					</xsl:when>
				</xsl:choose>
				<xsl:if test="./series">
					<xsl:value-of select="./series"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(./series)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./notes">
					<xsl:value-of select="./notes"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(./notes)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./book/vid">
					<xsl:text> vol. </xsl:text>
					<xsl:value-of select="normalize-space(./book/vid)"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./vid)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:apply-templates select="location"/>
				<xsl:if test="./isbn">
					<xsl:text> ISBN </xsl:text>
					<xsl:value-of select="normalize-space(./isbn)"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(./isbn)"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
			<!-- book subelements (not <text>) -->
		</xsl:choose>
	</xsl:template>
	<xsl:template match="claim">
		<a name="{@id}"/>
		<div class="leftPara">
			<table border="0" width="100%">
				<tr>
					<td width="8%" valign="top" class="para_ChoiceText">
						<!--	The numeric label for the claims will be displayed as [c#}.
The claims (elements claim) are individually and consecutively numbered by assigning Arabic numeral starting from 1 as a value of attribute "num" of each element "claim" within the XML instance of application-body.dtd (as specified in 37 CFR 1.75(f)).-->				
						[c<xsl:value-of select="@num"/>]
					</td>
					<td width="85%" valign="top" class="para_ChoiceText">
						<xsl:apply-templates/>
					</td>
					<td width="*"/>
				</tr>
			</table>
		</div>
	</xsl:template>
	<xsl:template match="claim-text">
		<xsl:choose>
			<xsl:when test="name(parent::*)='claim-text'">
				<div class="claim_ChoiceText">
					<xsl:apply-templates/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<!-- subsequent claim-texts break lines and indent -->
	</xsl:template>
	<xsl:template match="claim-ref">
		<b>
			<a href="#{@idref}">
				<xsl:apply-templates/>
			</a>
		</b>
	</xsl:template>
	<xsl:template match="bio-deposit">
		<a name="{@id}"/>
		<div>
			<b> Biological Deposit <xsl:value-of select="@num"/>
			</b>
			<br/>
			<b> Depository: </b>
			<xsl:value-of select="depositary"/>
			<br/>
			<b> Accession Number: </b>
			<xsl:value-of select="bio-accno"/>
			<xsl:if test="date">
				<br/>
				<b> Date (yyyymmdd): </b>
				<xsl:value-of select="substring(date,1,4)"/>-<xsl:value-of select="substring(date,5,2)"/>-<xsl:value-of select="substring(date,7,2)"/>
			</xsl:if>
			<xsl:if test="term">
				<br/>
				<b> Term: </b>
				<xsl:value-of select="term"/>
			</xsl:if>
			<xsl:if test="dtext">
				<br/>
				<b> Descriptive Text: </b>
				<xsl:value-of select="dtext"/>
			</xsl:if>
		</div>
	</xsl:template>
	<xsl:template match="br">
		<br/>
	</xsl:template>
	<xsl:template match="b">
		<b>
			<xsl:apply-templates/>
		</b>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="chemistry">
		<a name="{@id}"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="crossref">
		<b>
			<a href="#{@idref}">
				<xsl:apply-templates/>
			</a>
		</b>
	</xsl:template>
	<xsl:template match="depositary">
		<xsl:apply-templates/>
	</xsl:template>
	<!--...............................................................................-->
	<xsl:template match="dl">
		<a name="{@id}"/>
		<div>
			<b>Definition List <xsl:value-of select="substring-after(@id,'dl')"/>
			</b>
			<dl>
				<xsl:apply-templates/>
			</dl>
		</div>
	</xsl:template>
	<xsl:template match="dd">
		<dd>
			<b>Definition:</b>
			<xsl:apply-templates/>
		</dd>
	</xsl:template>
	<xsl:template match="dt">
		<a name="{@id}"/>
		<dt>
			<b>Term:</b>
			<xsl:apply-templates/>
		</dt>
	</xsl:template>
	<!--...............................................................................-->
	<xsl:template match="email">
		<span class="mono">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<xsl:template match="figref">
		<!-- generate target idref by attribute or key -->
		<b>
			<xsl:choose>
				<xsl:when test="@idref and not(@num)">
					<a href="#{@idref}">
						<xsl:apply-templates/>
					</a>
				</xsl:when>
				<xsl:when test="@num and not(@idref)">
					<a href="#{generate-id(key('fig_ref', @num))}">
						<xsl:value-of select="."/>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<a href="#{generate-id(key('fig_ref', @num))}">
						<xsl:value-of select="."/>
					</a>
				</xsl:otherwise>
			</xsl:choose>
		</b>
	</xsl:template>
	<xsl:template match="i">
		<i>
			<xsl:apply-templates/>
		</i>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="heading">
		<xsl:choose>
			<xsl:when test="@level='1'">
				<h2 class="heading">
					<xsl:apply-templates/>
				</h2>
			</xsl:when>
			<xsl:when test="@level='2'">
				<h3 class="heading">
					<xsl:apply-templates/>
				</h3>
			</xsl:when>
			<xsl:when test="@level='3'">
				<h4 class="heading">
					<xsl:apply-templates/>
				</h4>
			</xsl:when>
			<xsl:otherwise>
				<h3 class="heading">
					<xsl:apply-templates/>
				</h3>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="invention-title">
		<a name="{@id}"/>
		<h2 class="title">
			<xsl:apply-templates/>
		</h2>
	</xsl:template>
	<xsl:template match="li">
		<a name="{@id}"/>
		<xsl:choose>
			<xsl:when test="parent::ul[@list-style='bullet']">
				<div class="listItemBullet">
					<xsl:text>&#9679;</xsl:text>
					<xsl:apply-templates/>
				</div>
			</xsl:when>
			<xsl:when test="parent::ul[@list-style='dash']">
				<div class="listItemDash">
					<xsl:text>-  </xsl:text>
					<xsl:apply-templates/>
				</div>
			</xsl:when>
			<xsl:when test="parent::ul[@list-style='none']">
				<div class="listItemNone">
					<xsl:apply-templates/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<li>
					<xsl:apply-templates/>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="nplcit">
		<a name="{@id}"/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="ol">
		<a name="{@id}"/>
		<ol>
			<xsl:attribute name="type"><xsl:value-of select="@ol-style"/></xsl:attribute>
			<xsl:apply-templates/>
		</ol>
	</xsl:template>
	<xsl:template match="othercit">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="p[not(ancestor::abstract)]">
		<div class="leftPara">
			<a name="{@id}"/>
			<table border="0" width="100%">
				<tr>
					<td width="8%" valign="top" class="para_ChoiceText">
						<xsl:choose>
							<xsl:when test="string-length(@num)=3">
								[0<xsl:value-of select="@num"/>]
							</xsl:when>
							<xsl:when test="string-length(@num)=2">
								[00<xsl:value-of select="@num"/>]
							</xsl:when>
							<xsl:when test="string-length(@num)=1">
								[000<xsl:value-of select="@num"/>]
							</xsl:when>
							<xsl:otherwise>
								[<xsl:value-of select="@num"/>]
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td width="90%" class="para_ChoiceText">
						<xsl:apply-templates/>
					</td>
					<td width="*">&#160;</td>
				</tr>
			</table>
		</div>
	</xsl:template>
	<xsl:template match="smallcaps">
		<span style="font-size: 80%; font-variant: small-caps;">
			<xsl:apply-templates/>
		</span>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="sub">
		<span style="vertical-align: sub; font-size: 70%;">
			<xsl:apply-templates/>
		</span>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="sup">
		<span style="vertical-align: super; font-size: 70%;">
			<xsl:apply-templates/>
		</span>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="text()">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="u">
		<u>
			<xsl:apply-templates/>
		</u>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="ul">
		<a name="{@id}"/>
		<ul>
			<xsl:apply-templates/>
		</ul>
	</xsl:template>
	<xsl:template match="doc-page" mode="doc_page">
		<a name="{@id}"/>
		<xsl:choose>
			<xsl:when test="@type='jpg'">
				<img src="{@file}"/>
			</xsl:when>
			<xsl:when test="@type='pdf'">
				<embed src="{@file}" border="0">
					<xsl:variable name="height">
						<xsl:call-template name="get_size">
							<xsl:with-param name="size_in" select="@he"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="height"><xsl:value-of select="$height+46"/><!-- toolbar = 26px, bottom = 20px --></xsl:attribute>
					<xsl:variable name="width">
						<xsl:call-template name="get_size">
							<xsl:with-param name="size_in" select="@wi"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="width"><xsl:value-of select="$width+40"/><!-- Lside = 25px, Rside = 15px --></xsl:attribute>
				</embed>
			</xsl:when>
			<xsl:when test="@type='tif'">
				<embed toolbar="off" fit="best" align="top" src="{@file}">
					<xsl:attribute name="height"><xsl:call-template name="get_size"><xsl:with-param name="size_in" select="@he"/></xsl:call-template></xsl:attribute>
					<xsl:attribute name="width"><xsl:call-template name="get_size"><xsl:with-param name="size_in" select="@wi"/></xsl:call-template></xsl:attribute>
				</embed>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="figure">
		<a name="{@id}"/>
		<a name="{generate-id(.)}"/>
		<div class="leftPara">
			<!--h3>Figure <xsl:value-of select="@num"/>
			</h3-->
			<a name="{./img/@id}"/>
			<xsl:choose>
				<xsl:when test="./img/@img-format='tif'">
					<xsl:variable name="h">
						<xsl:call-template name="get_size">
							<xsl:with-param name="size_in" select="./img/@he"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="w">
						<xsl:call-template name="get_size">
							<xsl:with-param name="size_in" select="./img/@wi"/>
						</xsl:call-template>
					</xsl:variable>
					<embed toolbar="off" fit="best" align="top" src="{./img/@file}">
						<!-- Scaling Bits/pixel: 1 Resolution: 300.0 x 300.0 pixels/inch WEB 96 x 96 pix/inch-->
						<xsl:attribute name="height"><xsl:choose><xsl:when test="$h>936">936</xsl:when><xsl:when test="$h=0">936</xsl:when><xsl:otherwise><xsl:value-of select="$h"/></xsl:otherwise></xsl:choose></xsl:attribute>
						<xsl:attribute name="width"><xsl:choose><xsl:when test="$w>648">648</xsl:when><xsl:when test="$w=0">648</xsl:when><xsl:otherwise><xsl:value-of select="$w"/></xsl:otherwise></xsl:choose></xsl:attribute>
					</embed>
				</xsl:when>
				<xsl:when test="./img/@img-format='jpg'">
					<img src="{./img/@file}"/>
				</xsl:when>
			</xsl:choose>
		</div>
	</xsl:template>
	<!--............................................................-->
	<xsl:template match="img[not(ancestor::figure)]">
		<a name="{@id}"/>
		<xsl:choose>
			<xsl:when test="@img-format='tif'">
				<xsl:choose>
					<xsl:when test="@inline='no'">
						<p>
							<xsl:call-template name="tifimg"/>
						</p>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="tifimg"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@img-format='jpg'">
				<img src="{@file}"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--...................................................................-->
	<xsl:template name="tifimg">
		<xsl:variable name="w">
			<xsl:call-template name="get_size">
				<xsl:with-param name="size_in" select="@wi"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="h">
			<xsl:call-template name="get_size">
				<xsl:with-param name="size_in" select="@he"/>
			</xsl:call-template>
		</xsl:variable>
		<embed toolbar="off" fit="best" align="top" src="{@file}">
			<xsl:attribute name="height"><xsl:choose><xsl:when test="$h>888">888</xsl:when><xsl:when test="$h=0">888</xsl:when><xsl:otherwise><xsl:value-of select="$h"/></xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:attribute name="width"><xsl:choose><xsl:when test="$w>576">576</xsl:when><xsl:when test="$w=0">576</xsl:when><xsl:otherwise><xsl:value-of select="$w"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</embed>
	</xsl:template>
	<!--...................................................................-->
	<xsl:template match="location">
		<xsl:for-each select=".">
			<xsl:if test="./pp">
				<xsl:text> p. </xsl:text>
				<xsl:choose>
					<xsl:when test=".//ppf">
						<xsl:value-of select="normalize-space(.//ppf)"/>
						<xsl:if test=".//ppl">
							<xsl:text> to </xsl:text>
							<xsl:value-of select="normalize-space(.//ppl)"/>
							<xsl:choose>
								<xsl:when test=".//pp/following-sibling::*">
									<xsl:text>, </xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="format_period">
										<xsl:with-param name="string" select="normalize-space(.//ppl)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="normalize-space(.//pp)"/>
						<xsl:call-template name="format_period">
							<xsl:with-param name="string" select="normalize-space(.//pp)"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:if>
			<xsl:if test="./column">
				<xsl:text> col. </xsl:text>
				<xsl:choose>
					<xsl:when test=".//colf">
						<xsl:value-of select="normalize-space(.//colf)"/>
						<xsl:if test=".//coll">
							<xsl:text> to </xsl:text>
							<xsl:value-of select="normalize-space(.//coll)"/>
							<xsl:choose>
								<xsl:when test=".//column/following-sibling::*">
									<xsl:text>, </xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="format_period">
										<xsl:with-param name="string" select="normalize-space(.//coll)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="normalize-space(.//column)"/>
						<xsl:call-template name="format_period">
							<xsl:with-param name="string" select="normalize-space(.//column)"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:if>
			<xsl:if test="./para">
				<xsl:text> para. </xsl:text>
				<xsl:choose>
					<xsl:when test=".//paraf">
						<xsl:value-of select="normalize-space(.//paraf)"/>
						<xsl:if test=".//paral">
							<xsl:text> to </xsl:text>
							<xsl:value-of select="normalize-space(.//paral)"/>
							<xsl:choose>
								<xsl:when test=".//para/following-sibling::*">
									<xsl:text>, </xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="format_period">
										<xsl:with-param name="string" select="normalize-space(.//paral)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="normalize-space(.//para)"/>
						<xsl:call-template name="format_period">
							<xsl:with-param name="string" select="normalize-space(.//para)"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:if>
			<xsl:if test="./line">
				<xsl:text> line </xsl:text>
				<xsl:choose>
					<xsl:when test=".//linef">
						<xsl:value-of select="normalize-space(.//linef)"/>
						<xsl:if test=".//linel">
							<xsl:text> to </xsl:text>
							<xsl:value-of select="normalize-space(.//linel)"/>
							<xsl:choose>
								<xsl:when test=".//line/following-sibling::*">
									<xsl:text>, </xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="format_period">
										<xsl:with-param name="string" select="normalize-space(.//linel)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="normalize-space(.//line)"/>
						<xsl:call-template name="format_period">
							<xsl:with-param name="string" select="normalize-space(.//line)"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="online">
		<!-- param to pass the date to format_date template (formatting_functions.xsl) -->
		<xsl:param name="date" select="normalize-space(./pubdate)"/>
		<xsl:choose>
			<xsl:when test="./text">
				<!-- no sub-elements -->
				<xsl:value-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- online sub-elements -->
				<xsl:apply-templates select="author"/>
				<xsl:text/>
				<xsl:if test="./online-title">
					<xsl:variable name="nTitle" select="normalize-space(./online-title)"/>
					<xsl:variable name="nLen" select="string-length($nTitle)"/>
					<xsl:choose>
						<xsl:when test="substring($nTitle,$nLen)='.'">
							<xsl:call-template name="rtrim">
								<xsl:with-param name="string" select="$nTitle"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$nTitle"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="ancestor::nplcit[1]/@medium">
							<xsl:text> [</xsl:text>
							<xsl:value-of select="normalize-space(ancestor::nplcit[1]/@medium)"/>
							<xsl:text>].  </xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text> [online].  </xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="./subname">
					<xsl:apply-templates select="subname"/>
				</xsl:if>
				<!-- test for comma -->
				<xsl:choose>
					<!-- book | serial -->
					<xsl:when test=".//book-title">
						<i>
							<xsl:value-of select=".//book-title"/>
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//book-title)"/>
							</xsl:call-template>
							<xsl:text/>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<!-- serial -->
						<i>
							<xsl:value-of select="normalize-space(.//sertitle)"/>
						</i>
						<xsl:text/>
					</xsl:otherwise>
				</xsl:choose>
				<!-- end book-title | sertitle -->
				<xsl:if test=".//vid">
					<xsl:text> vol. </xsl:text>
					<xsl:value-of select=".//vid"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(.//vid)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test=".//ino">
					<xsl:text> no. </xsl:text>
					<xsl:value-of select=".//ino"/>
					<xsl:choose>
						<!-- if location elements present, write comma -->
						<xsl:when test=".//location">
							<xsl:call-template name="format_comma">
								<xsl:with-param name="string" select="normalize-space(.//ino)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!-- end with period -->
							<xsl:call-template name="format_period">
								<xsl:with-param name="string" select="normalize-space(.//ino)"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="./pubdate/sdate | ./pubdate/edate">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(./pubdate/sdate)"/>
							<xsl:with-param name="text" select="1"/>
							<xsl:with-param name="show_date" select="1"/>
							<xsl:with-param name="lang" select="$lang"/>
						</xsl:call-template>
						<xsl:if test="./pubdate/edate">
							<xsl:text>, Revised</xsl:text>
							<xsl:call-template name="format_date">
								<xsl:with-param name="date" select="normalize-space(./pubdate/edate)"/>
								<xsl:with-param name="text" select="1"/>
								<xsl:with-param name="show_date" select="1"/>
								<xsl:with-param name="lang" select="$lang"/>
							</xsl:call-template>
							<xsl:text>. </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test=" ./pubdate/text()">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(./pubdate)"/>
							<xsl:with-param name="text" select="1"/>
							<xsl:with-param name="show_date" select="1"/>
							<xsl:with-param name="lang" select="$lang"/>
						</xsl:call-template>
						<xsl:text>. </xsl:text>
					</xsl:when>
				</xsl:choose>
				<xsl:if test="./edition">
					<xsl:value-of select="./edition"/>
					<xsl:call-template name="format_comma">
						<xsl:with-param name="string" select="normalize-space(./edition)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./imprint">
					<xsl:choose>
						<xsl:when test=".//address/text">
							<xsl:value-of select="normalize-space(.//imprint/address/text)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test=".//address/city">
								<xsl:value-of select=".//address/city"/>
								<!-- if followed by <state>, display comma then state -->
								<xsl:if test=".//following-sibling::state">
									<xsl:call-template name="format_comma">
										<xsl:with-param name="string" select="normalize-space(.//address/city)"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:if>
							<xsl:if test=".//address/state">
								<xsl:value-of select=".//address/state"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="./imprint/name">
					<xsl:if test="./imprint/name/preceding-sibling::address">
						<xsl:text>: </xsl:text>
					</xsl:if>
					<xsl:value-of select="normalize-space(./imprint/name)"/>
				</xsl:if>
				<xsl:if test="./imprint/pubdate">
					<xsl:text/>
					<xsl:if test=".//pubdate/child::text()">
						<xsl:call-template name="format_date">
							<xsl:with-param name="date" select="normalize-space(.//pubdate)"/>
							<xsl:with-param name="text" select="1"/>
							<xsl:with-param name="lang" select="$lang"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
				<xsl:if test="datecit">
					<xsl:text>  [retrieved on </xsl:text>
					<xsl:call-template name="format_date">
						<xsl:with-param name="date" select="normalize-space(./datecit/date)"/>
						<xsl:with-param name="lang" select="$lang"/>
					</xsl:call-template>
					<xsl:text>]. </xsl:text>
				</xsl:if>
				<xsl:apply-templates select="location"/>
				<xsl:if test="notes">
					<xsl:value-of select="notes"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(notes)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:text>Retrieved from: </xsl:text>
				<xsl:text>&lt;</xsl:text>
				<xsl:value-of select="./avail"/>
				<xsl:text>&gt;</xsl:text>
				<xsl:call-template name="format_period">
					<xsl:with-param name="string" select="normalize-space(./avail)"/>
				</xsl:call-template>
				<xsl:if test="./issn">
					<xsl:text> ISSN </xsl:text>
					<xsl:value-of select="normalize-space(./issn)"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(./issn)"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./isbn">
					<xsl:text> ISBN </xsl:text>
					<xsl:value-of select="normalize-space(./isbn)"/>
					<xsl:call-template name="format_period">
						<xsl:with-param name="string" select="normalize-space(./isbn)"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
			<!-- end article subelements (not <text>) -->
		</xsl:choose>
	</xsl:template>
	<xsl:template match="patcit">
		<a name="{@id}"/>
		<div>
			<b>Patent Citation <xsl:value-of select="@num"/>: </b>
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	<xsl:template match="document-id">
		<a name="{@id}"/>
		<xsl:value-of select="country"/>
		<xsl:text/>
		<xsl:value-of select="doc-number"/>
		<xsl:text/>
		<xsl:value-of select="kind"/>
		<xsl:text/>
		<xsl:if test="name">
			<xsl:choose>
				<xsl:when test="starts-with(name,'(')">
					<xsl:call-template name="uppercaser">
						<xsl:with-param name="string" select="(name)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>(</xsl:text>
					<xsl:call-template name="uppercaser">
						<xsl:with-param name="string" select="(name)"/>
					</xsl:call-template>
					<xsl:text>).</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:text/>
		<xsl:call-template name="format_date">
			<xsl:with-param name="date" select="normalize-space(.//date)"/>
		</xsl:call-template>
		<xsl:call-template name="format_period">
			<xsl:with-param name="string" select="normalize-space(.//date)"/>
		</xsl:call-template>
		<xsl:text/>
	</xsl:template>
	<xsl:template match="rel-passage">
		<xsl:for-each select="./*">
			<xsl:choose>
				<xsl:when test="substring(normalize-space(.),string-length(normalize-space(.)))='.'">
					<xsl:value-of select="."/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="."/>
					<xsl:text>. </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="tables">
		<a name="{@id}"/>
		<xsl:choose>
			<xsl:when test="./img">
				<!--h3>Table <xsl:value-of select="@num"/>
				</h3-->
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<div style="page-break-inside: avoid; ">
					<xsl:apply-templates select="table"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="table">
		<!--span class="tableHead">
			<xsl:value-of select="./title"></xsl:value-of>
		</span-->
		<xsl:apply-templates select="tgroup"/>
	</xsl:template>
	<xsl:template match="tgroup">
		<table cellpadding="3" cellspacing="0">
			<!-- apply frame -->
			<xsl:choose>
				<xsl:when test="parent::table/@frame='top'">
					<xsl:attribute name="frame">above</xsl:attribute>
					<xsl:attribute name="rules">none</xsl:attribute>
				</xsl:when>
				<xsl:when test="parent::table/@frame='bottom'">
					<xsl:attribute name="frame">below</xsl:attribute>
					<xsl:attribute name="rules">none</xsl:attribute>
				</xsl:when>
				<xsl:when test="parent::table/@frame='topbot'">
					<xsl:attribute name="frame">hsides</xsl:attribute>
					<xsl:attribute name="rules">none</xsl:attribute>
				</xsl:when>
				<xsl:when test="parent::table/@frame='all'">
					<xsl:attribute name="frame">all</xsl:attribute>
					<xsl:attribute name="rules">all</xsl:attribute>
				</xsl:when>
				<xsl:when test="parent::table/@frame='sides'">
					<xsl:attribute name="frame">vsides</xsl:attribute>
					<xsl:attribute name="rules">none</xsl:attribute>
				</xsl:when>
				<xsl:when test="parent::table/@frame='none'">
					<xsl:attribute name="frame">void</xsl:attribute>
					<xsl:attribute name="rules">none</xsl:attribute>
				</xsl:when>
				<!-- no frame specified, use 'all' as default -->
				<xsl:otherwise>
					<xsl:attribute name="frame">all</xsl:attribute>
					<xsl:attribute name="rules">all</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="border"><xsl:choose><xsl:when test="parent::table/@frame='none'">0</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:attribute>
			<!-- Do we need colgroup? ...No practice in HTML...........................-->
			<!--xsl:if test=".//colspec">
				<colgroup>
					<xsl:apply-templates select="colspec"></xsl:apply-templates>
				</colgroup>
			</xsl:if-->
			<xsl:if test="parent::table/title">
				<caption class="tableHead">
					<xsl:value-of select="parent::table/title"/>
				</caption>
			</xsl:if>
			<xsl:if test=".//thead">
				<thead>
					<xsl:apply-templates select="thead"/>
				</thead>
			</xsl:if>
			<xsl:apply-templates select="tbody"/>
		</table>
	</xsl:template>
	<xsl:template match="tbody">
		<tbody>
			<xsl:if test="@valign">
				<xsl:attribute name="valine"><xsl:value-of select="@valign"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</tbody>
	</xsl:template>
	<xsl:template match="thead">
		<xsl:apply-templates/>
	</xsl:template>
	<!-- Do we need colgroup and col in the table? ........................-->
	<!--xsl:template match="colspec">
		<xsl:for-each select=".">
			<col>
				<xsl:attribute name="width"><xsl:call-template name="calc.column.width">						<xsl:with-param name="colwidth"><xsl:value-of select="@colwidth">						</xsl:value-of></xsl:with-param></xsl:call-template>
				</xsl:attribute>
				<xsl:apply-templates></xsl:apply-templates>
			</col>
		</xsl:for-each>
	</xsl:template-->
	<!--.............................................-->
	<xsl:template match="row">
		<tr>
			<xsl:if test="@valign">
				<xsl:attribute name="valign"><xsl:value-of select="@valign"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="entry"/>
		</tr>
	</xsl:template>
	<!-- ............A big block of calcs for col width.................-->
	<xsl:template name="calc.column.width">
		<!--
		 * @param colwidth The column width specification.
		 *
		 * @returns The XSL column width specification.
		 * -->
		<xsl:param name="colwidth">1*</xsl:param>
		<!-- Ok, the colwidth could have any one of the following forms: -->
		<!--        1*       = proportional width -->
		<!--     1unit       = 1.0 units wide -->
		<!--         1       = 1pt wide -->
		<!--  1*+1unit       = proportional width + some fixed width -->
		<!--      1*+1       = proportional width + some fixed width -->
		<!-- If it has a proportional width, translate it to XSL -->
		<xsl:if test="contains($colwidth, '*')">
			<xsl:text>proportional-column-width(</xsl:text>
			<xsl:value-of select="substring-before($colwidth, '*')"/>
			<xsl:text>)</xsl:text>
		</xsl:if>
		<!-- Now get the non-proportional part of the specification -->
		<xsl:variable name="width-units">
			<xsl:choose>
				<xsl:when test="contains($colwidth, '*')">
					<xsl:value-of select="normalize-space(substring-after($colwidth, '*'))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="normalize-space($colwidth)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Now the width-units could have any one of the following forms: -->
		<!--                 = <empty string> -->
		<!--     1unit       = 1.0 units wide -->
		<!--         1       = 1pt wide -->
		<!-- with an optional leading sign -->
		<!-- Get the width part by blanking out the units part and discarding -->
		<!-- white space. -->
		<xsl:variable name="width" select="normalize-space(translate($width-units,&#xA;                                        '+-0123456789.abcdefghijklmnopqrstuvwxyz',             &#xA;                                        '+-0123456789.'))"/>
		<!-- Get the units part by blanking out the width part and discarding -->
		<!-- white space. -->
		<xsl:variable name="units" select="normalize-space(translate($width-units,             &#xA;                                         'abcdefghijklmnopqrstuvwxyz+-0123456789.',             &#xA;                                         'abcdefghijklmnopqrstuvwxyz'))"/>
		<!-- Output the units, translated appropriately -->
		<!-- NOTE: assumes 'small' font/icon size on Windows, 96 dpi -->
		<xsl:choose>
			<xsl:when test="$units = 'in'">
				<xsl:value-of select="round($width * 96)"/>
			</xsl:when>
			<xsl:when test="$units = 'cm'">
				<xsl:value-of select="round($width * 37.8)"/>
			</xsl:when>
			<xsl:when test="$units = 'mm'">
				<xsl:value-of select="round($width * 3.78)"/>
			</xsl:when>
			<xsl:when test="$units = '' and $width != ''">
				<xsl:value-of select="$units"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$units"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--...................Merging horizontally..........................-->
	<xsl:template name="calc.colspan">
		<!-- generate 'colspan' attribute from 'namest', 'nameend' -->
		<xsl:param name="namest"/>
		<!-- incoming @namest -->
		<xsl:param name="nameend"/>
		<!-- incoming @nameend -->
		<!-- get the positions of the column with the colname that 
			     matches @namest, @nameend -->
		<xsl:variable name="start">
			<xsl:for-each select="ancestor::tgroup[1]/child::colspec">
				<xsl:if test="@colname = $namest">
					<xsl:value-of select="position()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="end">
			<xsl:for-each select="ancestor::tgroup[1]/child::colspec">
				<xsl:if test="@colname = $nameend">
					<xsl:value-of select="position()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:attribute name="colspan"><xsl:value-of select="$end - $start + 1"/></xsl:attribute>
	</xsl:template>
	<!--.............................................-->
	<xsl:template match="entry">
		<xsl:choose>
			<xsl:when test="ancestor::thead">
				<xsl:element name="th">
					<xsl:call-template name="cell-attr"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="td">
					<xsl:call-template name="cell-attr"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="cell-attr">
		<xsl:if test="@align">
			<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
		</xsl:if>
		<!--...................Merging vertically..........................-->
		<xsl:if test="@morerows">
			<xsl:attribute name="rowspan"><xsl:value-of select="@morerows+1"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="@namest">
			<!-- ensure that colnames have been declared -->
			<xsl:if test="ancestor::tgroup[1]/child::colspec">
				<xsl:call-template name="calc.colspan">
					<xsl:with-param name="namest">
						<xsl:value-of select="@namest"/>
					</xsl:with-param>
					<xsl:with-param name="nameend">
						<xsl:value-of select="@nameend"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<!-- insert space in empty <entry>s to preserve width -->
		<xsl:if test="not(child::*)">
			<xsl:text>&#160;</xsl:text>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template name="get_size">
		<xsl:param name="size_in"/>
		<!-- NOTE: assumes screen resolution of 96 DPI (small icons) -->
		<!-- strip any units from attributes for mathematical operations to follow -->
		<xsl:variable name="unit" select="normalize-space(translate($size_in,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',''))"/>
		<xsl:variable name="nSize" select="translate($size_in,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		<xsl:variable name="size_out">
			<xsl:choose>
				<!-- if measured in milimeters -->
				<xsl:when test="contains($nSize,'MM')">
					<xsl:value-of select="round(number($unit) div 25.4 * 96)"/>
				</xsl:when>
				<!-- if measured in centimeters -->
				<xsl:when test="contains($nSize,'CM')">
					<xsl:value-of select="round(number($unit) div 2.54 * 96)"/>
				</xsl:when>
				<!-- if measured in inches -->
				<xsl:when test="contains($nSize,'IN')">
					<xsl:value-of select="round(number($unit) * 96)"/>
				</xsl:when>
				<!-- if measured in pixels; NOTE: assumes 300 dpi scan -->
				<xsl:when test="contains($nSize,'PX')">
					<xsl:value-of select="round(number($unit) div 300 * 96)"/>
				</xsl:when>
				<!-- use mm as default -->
				<xsl:otherwise>
					<xsl:value-of select="round(number($unit) div 25.4 * 96)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$size_out"/>
	</xsl:template>
	<xsl:template name="format_date">
		<xsl:param name="lang"/>
		<xsl:param name="date"/>
		<xsl:param name="text"/>
		<xsl:param name="year_only"/>
		<xsl:param name="show_date"/>
		<xsl:param name="add_comma"/>
		<xsl:param name="nDate">
			<xsl:value-of select="normalize-space(translate($date,'/\.,-',''))"/>
		</xsl:param>
		<xsl:param name="y" select="substring($nDate, 1,4)"/>
		<xsl:param name="m" select="substring($nDate,5,2)"/>
		<xsl:param name="d" select="substring($nDate,7,2)"/>
		<xsl:choose>
			<xsl:when test="$year_only='1'">
				<xsl:value-of select="$y"/>
			</xsl:when>
			<xsl:when test="$text != '1'">
				<xsl:value-of select="$y"/>-<xsl:value-of select="$m"/>-<xsl:value-of select="$d"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$show_date='1'">
					<xsl:text/>
					<xsl:value-of select="$d"/>
					<xsl:text/>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="$m='01'">
						<xsl:text> January </xsl:text>
					</xsl:when>
					<xsl:when test="$m='02'">
						<xsl:text> February </xsl:text>
					</xsl:when>
					<xsl:when test="$m='03'">
						<xsl:text> March </xsl:text>
					</xsl:when>
					<xsl:when test="$m='04'">
						<xsl:text> April </xsl:text>
					</xsl:when>
					<xsl:when test="$m='05'">
						<xsl:text> May </xsl:text>
					</xsl:when>
					<xsl:when test="$m = '06'">
						<xsl:text> June </xsl:text>
					</xsl:when>
					<xsl:when test="$m='07'">
						<xsl:text> July </xsl:text>
					</xsl:when>
					<xsl:when test="$m='08'">
						<xsl:text> August </xsl:text>
					</xsl:when>
					<xsl:when test="$m='09'">
						<xsl:text> September </xsl:text>
					</xsl:when>
					<xsl:when test="$m='10'">
						<xsl:text> October </xsl:text>
					</xsl:when>
					<xsl:when test="$m='11'">
						<xsl:text> November </xsl:text>
					</xsl:when>
					<xsl:when test="$m='12'">
						<xsl:text> December </xsl:text>
					</xsl:when>
					<!-- trap error (e.g., 1-digit month) -->
					<xsl:otherwise>
						<xsl:value-of select="$m"/>
						<xsl:value-of select="$d"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$y"/>
				<xsl:if test="$add_comma='1'">
					<xsl:text>, </xsl:text>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="uppercaser">
		<xsl:param name="string"/>
		<xsl:value-of select="translate(normalize-space($string),'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	</xsl:template>
	<xsl:template name="format_period">
		<xsl:param name="string"/>
		<xsl:param name="len" select="string-length($string)"/>
		<xsl:choose>
			<xsl:when test="substring($string,$len)='.'"/>
			<!-- do nothing -->
			<xsl:otherwise>
				<xsl:text>.  </xsl:text>
				<!-- add period -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="format_comma">
		<xsl:param name="string"/>
		<xsl:param name="len" select="string-length($string)"/>
		<xsl:choose>
			<xsl:when test="substring($string,$len)=','">
				<xsl:text/>
			</xsl:when>
			<!-- do nothing -->
			<xsl:otherwise>
				<xsl:text>, </xsl:text>
				<!-- add comma -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="rtrim">
		<xsl:param name="string"/>
		<xsl:param name="len" select="string-length($string)"/>
		<xsl:param name="cut" select="number($len)-1"/>
		<xsl:value-of select="substring($string,1,$cut)"/>
	</xsl:template>
	<xsl:template name="name_group">
		<xsl:if test="./name">
			<xsl:value-of select="./name"/>
		</xsl:if>
		<xsl:if test="./prefix">
			<xsl:value-of select="./prefix"/>
			<xsl:text>&#160;</xsl:text>
		</xsl:if>
		<xsl:if test="./last-name">
			<xsl:call-template name="uppercaser">
				<xsl:with-param name="string" select="./last-name"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="./first-name">
			<xsl:text>, </xsl:text>
			<xsl:value-of select="./first-name"/>
		</xsl:if>
		<xsl:if test="./middle-name">
			<xsl:text>&#160;</xsl:text>
			<xsl:value-of select="./middle-name"/>
		</xsl:if>
		<xsl:if test="./suffix">
			<xsl:text>&#160;</xsl:text>
			<xsl:value-of select="./suffix"/>
		</xsl:if>
		<xsl:if test="./role">
			<xsl:text>, Role: </xsl:text>
			<xsl:value-of select="./role"/>
		</xsl:if>
		<xsl:if test="./orgname">
			<xsl:choose>
				<xsl:when test="not(child::last-name)">
					<xsl:call-template name="uppercaser">
						<xsl:with-param name="string" select="./orgname"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>, Organization: </xsl:text>
					<xsl:value-of select="./orgname"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="./iid">
			<xsl:text>, ID: </xsl:text>
			<xsl:value-of select="./iid"/>
		</xsl:if>
		<xsl:if test="./department">
			<xsl:text>, Department: </xsl:text>
			<xsl:value-of select="./department"/>
		</xsl:if>
		<xsl:if test="./synonym">
			<xsl:text>, Synonyms: </xsl:text>
			<xsl:apply-templates select="./synonym"/>
		</xsl:if>
		<xsl:if test="./registered-number">
			<xsl:text>, Registered-number: </xsl:text>
			<xsl:value-of select="./registered-number"/>
		</xsl:if>
		<xsl:if test="position()!=last()">
			<xsl:text>; </xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template name="address_group">
		<!-- Separator is space for address elements -->
		<xsl:choose>
			<xsl:when test="./text">
				<xsl:value-of select="./text"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="./address-1">
					<xsl:value-of select="./address-1"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./address-2">
					<xsl:value-of select="./address-2"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./address-3">
					<xsl:value-of select="./address-3"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./mailcode">
					<xsl:value-of select="./mailcode"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./pobox">
					<xsl:value-of select="./pobox"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./room">
					<xsl:value-of select="./room"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./floor">
					<xsl:value-of select="./floor"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./building">
					<xsl:value-of select="./building"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./street">
					<xsl:value-of select="./street"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./city">
					<xsl:value-of select="./city"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./county">
					<xsl:value-of select="./county"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./state">
					<xsl:value-of select="./state"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:if test="./postcode">
					<xsl:value-of select="./postcode"/>
					<xsl:text>&#160;</xsl:text>
				</xsl:if>
				<xsl:value-of select="country"/>
				<xsl:text>&#160;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="attachedDoc_ChoiceText">
		<xsl:choose>
			<xsl:when test="$lang='en'">
				<xsl:text> (scanned image attached) </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text> (scanned image attached) </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="file_ChoiceText">
		<xsl:if test="$lang='en'">
			<xsl:text> file:   </xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- Comment for matching size
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************
****************************************-->
</xsl:stylesheet>
